;Copyright (C) 2004-2008 John T. Haller

;Website: http://PortableApps.com/GIMPPortable

;This software is OSI Certified Open Source Software.
;OSI Certified is a certification mark of the Open Source Initiative.

;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.

;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.

;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

!define PORTABLEAPPNAME "GIMP Portable"
!define APPNAME "GIMP"
!define NAME "GIMPPortable"
!define VER "1.5.7.0"
!define WEBSITE "PortableApps.com/GIMPPortable"
!define DEFAULTEXE "gimp-2.4.exe"
!define DEFAULTAPPDIR "gimp"
!define DEFAULTGTKDIR "gtk"
!define DEFAULTSETTINGSDIR "settings"

;=== Program Details
Name "${PORTABLEAPPNAME}"
OutFile "..\..\${NAME}.exe"
Caption "${PORTABLEAPPNAME} | PortableApps.com"
VIProductVersion "${VER}"
VIAddVersionKey ProductName "${PORTABLEAPPNAME}"
VIAddVersionKey Comments "Allows ${APPNAME} to be run from a removable drive.  For additional details, visit ${WEBSITE}"
VIAddVersionKey CompanyName "PortableApps.com"
VIAddVersionKey LegalCopyright "John T. Haller"
VIAddVersionKey FileDescription "${PORTABLEAPPNAME}"
VIAddVersionKey FileVersion "${VER}"
VIAddVersionKey ProductVersion "${VER}"
VIAddVersionKey InternalName "${PORTABLEAPPNAME}"
VIAddVersionKey LegalTrademarks "PortableApps.com is a Trademark of Rare Ideas, LLC."
VIAddVersionKey OriginalFilename "${NAME}.exe"
;VIAddVersionKey PrivateBuild ""
;VIAddVersionKey SpecialBuild ""


;=== Runtime Switches
CRCCheck On
WindowIcon Off
SilentInstall Silent
AutoCloseWindow True
RequestExecutionLevel user

; Best Compression
SetCompress Auto
SetCompressor /SOLID lzma
SetCompressorDictSize 32
SetDatablockOptimize On

;=== Include
!include "GetParameters.nsh"
!include "GetParent.nsh"
!include "ReplaceInFile.nsh"
!include "StrRep.nsh"
!include "MUI.nsh"
!include "Registry.nsh"

;=== Program Icon
Icon "..\..\App\AppInfo\appicon.ico"

;=== Icon & Stye ===
!define MUI_ICON "..\..\App\AppInfo\appicon.ico"

;=== Languages
!insertmacro MUI_LANGUAGE "English"

LangString LauncherFileNotFound ${LANG_ENGLISH} "${PORTABLEAPPNAME} cannot be started. You may wish to re-install to fix this issue. (ERROR: $MISSINGFILEORPATH could not be found)"
LangString LauncherAlreadyRunning ${LANG_ENGLISH} "Another instance of ${APPNAME} is already running. Please close other instances of ${APPNAME} before launching ${PORTABLEAPPNAME}."
LangString LauncherAskCopyLocal ${LANG_ENGLISH} "${PORTABLEAPPNAME} appears to be running from a location that is read-only. Would you like to temporarily copy it to the local hard drive and run it from there?$\n$\nPrivacy Note: If you say Yes, your personal data within ${PORTABLEAPPNAME} will be temporarily copied to a local drive. Although this copy of your data will be deleted when you close ${PORTABLEAPPNAME}, it may be possible for someone else to access your data later."
LangString LauncherNoReadOnly ${LANG_ENGLISH} "${PORTABLEAPPNAME} can not run directly from a read-only location and will now close."

Var PROGRAMDIRECTORY
Var GTKDIRECTORY
Var SETTINGSDIRECTORY
Var ADDITIONALPARAMETERS
Var EXECSTRING
Var PROGRAMEXECUTABLE
Var INIPATH
Var ISDEFAULTDIRECTORY
Var GIMPLANGUAGE
Var RENAMEDINCOMPATIBLEFILES
Var AUTOFIXINCOMPATIBLEFILES
Var EXISTSTHUMBNAILS
Var EXISTSFONTSCACHE
Var EXISTSGTKBOOKMARKS
Var USERPROFILE
Var MISSINGFILEORPATH
Var USERTYPE
Var FAILEDTORESTOREKEY

Section "Main"
	;=== Find the INI file, if there is one
		IfFileExists "$EXEDIR\${NAME}.ini" "" NoINI
			StrCpy $INIPATH $EXEDIR
			Goto ReadINI

	ReadINI:
		;=== Read the parameters from the INI file
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "${APPNAME}Directory"
		StrCpy $PROGRAMDIRECTORY "$EXEDIR\$0"
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "GTKDirectory"
		StrCpy $GTKDIRECTORY "$EXEDIR\$0"
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "SettingsDirectory"
		StrCpy $SETTINGSDIRECTORY "$EXEDIR\$0"

		;=== Check that the above required parameters are present
		IfErrors NoINI

		ReadINIStr $ADDITIONALPARAMETERS "$INIPATH\${NAME}.ini" "${NAME}" "AdditionalParameters"
		ReadINIStr $AUTOFIXINCOMPATIBLEFILES "$INIPATH\${NAME}.ini" "${NAME}" "AutofixIncompatibleFiles"
		ReadINIStr $PROGRAMEXECUTABLE "$INIPATH\${NAME}.ini" "${NAME}" "${APPNAME}Executable"
	
		;=== Any missing unrequired INI entries will be an empty string, ignore associated errors
		ClearErrors

		;=== Correct PROGRAMEXECUTABLE if blank
		StrCmp $PROGRAMEXECUTABLE "" "" EndINI
			StrCpy $PROGRAMEXECUTABLE "${DEFAULTEXE}"
			Goto EndINI

	NoINI:
		;=== No INI file, so we'll use the defaults
		StrCpy $ADDITIONALPARAMETERS ""
		StrCpy $PROGRAMEXECUTABLE "${DEFAULTEXE}"

		IfFileExists "$EXEDIR\App\${DEFAULTAPPDIR}\bin\${DEFAULTEXE}" "" NoProgramEXE
			StrCpy $PROGRAMDIRECTORY "$EXEDIR\App\${DEFAULTAPPDIR}"
			StrCpy $SETTINGSDIRECTORY "$EXEDIR\Data\${DEFAULTSETTINGSDIR}"
			StrCpy $ISDEFAULTDIRECTORY "true"
			;=== Check GTK directory
			IfFileExists "$EXEDIR\App\${DEFAULTAPPDIR}\bin\libgtk-win32*.*" "" GTKSeparate
				StrCpy $GTKDIRECTORY "NONE"
				Goto EndINI

			GTKSeparate:
				IfFileExists "$EXEDIR\App\${DEFAULTGTKDIR}\bin\*.*" "" GTKCommonFiles
					StrCpy $GTKDIRECTORY "$EXEDIR\App\${DEFAULTGTKDIR}"
					Goto EndINI

			GTKCommonFiles:
				Push $EXEDIR
				Call GetParent
				Pop $0
				StrCpy $GTKDIRECTORY "$0\CommonFiles\GTK"
				GoTo EndINI
	
	EndINI:
		;=== Check if already running
		System::Call 'kernel32::CreateMutexA(i 0, i 0, t "${NAME}") i .r1 ?e'
		Pop $0
		StrCmp $0 0 CheckForEXE LaunchAndExit
	
	CheckForEXE:
		IfFileExists "$PROGRAMDIRECTORY\bin\$PROGRAMEXECUTABLE" FoundProgramEXE

	NoProgramEXE:
		;=== Program executable not where expected
		StrCpy $MISSINGFILEORPATH $PROGRAMEXECUTABLE
		MessageBox MB_OK|MB_ICONEXCLAMATION `$(LauncherFileNotFound)`
		Abort
		
	FoundProgramEXE:
		FindProcDLL::FindProc "$PROGRAMEXECUTABLE"
		StrCmp $R0 "1" "" CheckForIncompatibleFiles
		MessageBox MB_OK|MB_ICONINFORMATION `$(LauncherAlreadyRunning)`
		Abort
	
	CheckForIncompatibleFiles:
		;=== Check for incompatible files
		IfFileExists "$WINDIR\system32\xmlparse.dll" IncompatibleFilesFound
		IfFileExists "$WINDIR\system32\xmltok.dll" IncompatibleFilesFound
		IfFileExists "$WINDIR\system\xmlparse.dll" IncompatibleFilesFound
		IfFileExists "$WINDIR\system\xmltok.dll" IncompatibleFilesFound
		Goto IncompatibleFilesHandled
		
	IncompatibleFilesFound:
		StrCmp $AUTOFIXINCOMPATIBLEFILES "true" FixIncompatibleFiles
		MessageBox MB_YESNO|MB_ICONQUESTION `Some files (xmlparse.dll, xmltok.dll) were found on this PC that are incompatible with ${PORTABLEAPPNAME}.  Would you like to temporariliy disable these files while ${PORTABLEAPPNAME} is running?` IDYES FixIncompatibleFiles
		MessageBox MB_YESNO|MB_ICONQUESTION `Without disabling these files, ${PORTABLEAPPNAME} may fail to work correctly.  Would you like to continue using ${PORTABLEAPPNAME} anyway?` IDYES IncompatibleFilesHandled
		Goto TheEnd
		
	FixIncompatibleFiles:
		Rename "$WINDIR\system32\xmlparse.dll" "$WINDIR\system32\xmlparse.dll.disabled"
		Rename "$WINDIR\system32\xmltok.dll" "$WINDIR\system32\xmltok.dll.disabled"
		Rename "$WINDIR\system\xmlparse.dll" "$WINDIR\system\xmlparse.dll.disabled"
		Rename "$WINDIR\system\xmltok.dll" "$WINDIR\system\xmltok.dll.disabled"
		StrCpy $RENAMEDINCOMPATIBLEFILES "true"
	
	IncompatibleFilesHandled:
		;=== Get any passed parameters
		Call GetParameters
		Pop $0
		StrCmp "'$0'" "''" "" LaunchProgramParameters

		;=== No parameters
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\bin\$PROGRAMEXECUTABLE"`
		Goto AdditionalParameters

	LaunchProgramParameters:
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\bin\$PROGRAMEXECUTABLE" $0`

	AdditionalParameters:
		StrCmp $ADDITIONALPARAMETERS "" GIMPEnvironment
		StrCpy $EXECSTRING `$EXECSTRING $ADDITIONALPARAMETERS`

	GIMPEnvironment:
		;=== Set the %GAIMHOME% directory if we have a path
		StrCmp $SETTINGSDIRECTORY "" GIMPSettingsNotFound
		IfFileExists "$SETTINGSDIRECTORY\*.*" GIMPSettingsFound
	
	GIMPSettingsNotFound:
		StrCmp $ISDEFAULTDIRECTORY "true" SetupDefaultSettings
		StrCpy $MISSINGFILEORPATH $SETTINGSDIRECTORY
		MessageBox MB_OK|MB_ICONEXCLAMATION `$(LauncherFileNotFound)`
		Abort

	SetupDefaultSettings:
		CreateDirectory "$EXEDIR\Data"
		CreateDirectory "$EXEDIR\Data\settings"
		CopyFiles /SILENT $EXEDIR\App\DefaultData\settings\*.* $EXEDIR\Data\settings
	
	GIMPSettingsFound:
		System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("GIMP2_DIRECTORY", "$SETTINGSDIRECTORY").r0'
		System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("HOME", "$SETTINGSDIRECTORY").r0'
		GoTo GTKDirectory

	GTKDirectory:
		StrCmp $GTKDIRECTORY "NONE" NoGTKPath
		IfFileExists "$GTKDIRECTORY\libgtk-win32*.*" "" NoGTKPath
		;=== Add GTK to the %PATH% directory if we have a path, otherwise, skip it
		;StrCpy $0 "$GTKDIRECTORY\bin;$PROGRAMDIRECTORY\bin"
		;System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("PATH", "$0").r0'
		System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("GTK_BASEPATH", "$GTKDIRECTORY").r0'
		Goto GIMPLanguage
		
	NoGTKPath:
		;StrCpy $0 "$PROGRAMDIRECTORY\bin"
		;System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("PATH", "$0").r0'
	
	GIMPLANGUAGE:
		ReadEnvStr $GIMPLANGUAGE "PortableApps.comLocaleglibc"
		StrCmp $GIMPLANGUAGE "" GIMPLanguageSettingsFile
		StrCmp $GIMPLANGUAGE "en_US" SetGIMPLanuageVariable
		IfFileExists "$PROGRAMDIRECTORY\App\gimp\lib\locale\$GIMPLANGUAGE\*.*" SetGIMPLanuageVariable GIMPLanguageSettingsFile
		
	GIMPLanguageSettingsFile:
		ReadINIStr $GIMPLANGUAGE "$SETTINGSDIRECTORY\${NAME}Settings.ini" "Language" "LANG"
		StrCmp $GIMPLANGUAGE "" UpdatePluginsRC
		StrCmp $GIMPLANGUAGE "en_US" SetGIMPLanuageVariable
		IfFileExists "$PROGRAMDIRECTORY\App\gimp\lib\locale\$GIMPLANGUAGE\*.*" SetGIMPLanuageVariable UpdatePluginsRC
		
	SetGIMPLanuageVariable:
		System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("LANG", "$GIMPLANGUAGE").r0'

	UpdatePluginsRC:
		; double up back slashes and store current directory in $2
		${StrReplace} '$1' '\' '??' '$EXEDIR'
		${StrReplace} '$2' '??' '\\' '$1'
		;get last directory and store in $0
		ReadINIStr $0 "$SETTINGSDIRECTORY\${NAME}Settings.ini" "GIMPPortableSettings" "LastDirectory"
		StrCmp $0 "" StoreLastDirectory
		StrCmp $0 $2 CheckForUserProfileFolders ; No change, so just start
		IfFileExists "$SETTINGSDIRECTORY\pluginrc" "" StoreLastDirectory
		${ReplaceInFile} "$SETTINGSDIRECTORY\pluginrc" "$0" "$$OLDDIRECTORY$$"
		${ReplaceInFile} "$SETTINGSDIRECTORY\pluginrc" "$$OLDDIRECTORY$$" "$2"

	StoreLastDirectory:
		WriteINIStr "$SETTINGSDIRECTORY\${NAME}Settings.ini" "GIMPPortableSettings" "LastDirectory" $2
	
	CheckForUserProfileFolders:
		ReadEnvStr $USERPROFILE "USERPROFILE"
		IfFileExists "$USERPROFILE\.fonts.cache-1" 0 +2
		StrCpy $EXISTSFONTSCACHE "true"
		IfFileExists "$USERPROFILE\.gtk-bookmarks" 0 +2
		StrCpy $EXISTSGTKBOOKMARKS "true"
		IfFileExists "$USERPROFILE\.thumbnails\*.*" 0 +2
		StrCpy $EXISTSTHUMBNAILS "true"
		SetOutPath "$PROGRAMDIRECTORY\bin"
		
		IfFileExists "$PROGRAMDIRECTORY\lib\gimp\2.0\plug-ins\gimpportablebgwindow.exe" "" LaunchNow
		UserInfo::GetAccountType
		Pop $USERTYPE
		StrCmp $USERTYPE "Guest" LaunchNow
		StrCmp $USERTYPE "User" LaunchNow
		${registry::KeyExists} "HKEY_LOCAL_MACHINE\SOFTWARE\GIMPBgPortable" $R0
		StrCmp $R0 "-1" +3 ;=== If it doesn't exist, skip the next 2 lines
		${registry::MoveKey} "HKEY_LOCAL_MACHINE\SOFTWARE\GIMPBgPortable" "HKEY_LOCAL_MACHINE\SOFTWARE\GIMPBgPortable-BackupByGIMPPortable" $R0
		Sleep 100
		IfFileExists "$SETTINGSDIRECTORY\gimpportablebgwindow.reg" "" LaunchNow
	
		IfFileExists "$WINDIR\system32\reg.exe" "" RestoreTheKey9x
			nsExec::ExecToStack `"$WINDIR\system32\reg.exe" import "$SETTINGSDIRECTORY\gimpportablebgwindow.reg"`
			Pop $R0
			StrCmp $R0 '0' LaunchNow ;successfully restored key
	RestoreTheKey9x:
		${registry::RestoreKey} "$SETTINGSDIRECTORY\gimpportablebgwindow.reg" $R0
		StrCmp $R0 '0' LaunchNow ;successfully restored key
		StrCpy $FAILEDTORESTOREKEY "true"
		
	LaunchNow:
		ExecWait $EXECSTRING
		StrCmp $RENAMEDINCOMPATIBLEFILES "true" "" CleanupBackgroundPluginRegistry
		Rename "$WINDIR\system32\xmlparse.dll.disabled" "$WINDIR\system32\xmlparse.dll"
		Rename "$WINDIR\system32\xmltok.dll.disabled" "$WINDIR\system32\xmltok.dll"
		Rename "$WINDIR\system\xmlparse.dll.disabled" "$WINDIR\system\xmlparse.dll"
		Rename "$WINDIR\system\xmltok.dll.disabled" "$WINDIR\system\xmltok.dll"

	CleanupBackgroundPluginRegistry:
		IfFileExists "$PROGRAMDIRECTORY\lib\gimp\2.0\plug-ins\gimpportablebgwindow.exe" "" TheEnd
		StrCmp $USERTYPE "Guest" TheEnd
		StrCmp $USERTYPE "User" TheEnd
		StrCmp $FAILEDTORESTOREKEY "true" SetOriginalKeyBack
		${registry::SaveKey} "HKEY_LOCAL_MACHINE\SOFTWARE\GIMPBgPortable" "$SETTINGSDIRECTORY\gimpportablebgwindow.reg" "" $0
		Sleep 100
	
	SetOriginalKeyBack:
		${registry::DeleteKey} "HKEY_LOCAL_MACHINE\SOFTWARE\GIMPBgPortable" $R0
		Sleep 100
		${registry::KeyExists} "HKEY_LOCAL_MACHINE\SOFTWARE\GIMPBgPortable-BackupByGIMPPortable" $R0
		StrCmp $R0 "-1" TheEnd
		${registry::MoveKey} "HKEY_LOCAL_MACHINE\SOFTWARE\GIMPBgPortable-BackupByGIMPPortable" "HKEY_LOCAL_MACHINE\SOFTWARE\GIMPBgPortable" $R0
		Sleep 100
		Goto TheEnd
		
	LaunchAndExit:
		Call GetParameters
		Pop $0
		StrCmp "'$0'" "''" BringGIMPToFront
		Exec '"$EXEDIR\App\gimp\bin\gimp-win-remote.exe" $PROGRAMEXECUTABLE $0'
		Goto TheRealEnd
		
	BringGIMPToFront:
		FindWindow $0 'The GIMP'
		IntCmp $0 0 TheRealEnd
			System::Call "user32::ShowWindow(i $0,i 9) i."         ; If minimized then maximize
			System::Call 'user32::SetForegroundWindow(i $0) i ?e'
		Goto TheRealEnd
		
	TheEnd:
		StrCmp $EXISTSFONTSCACHE "true" +2
		Delete "$USERPROFILE\.fonts.cache-1"
		StrCmp $EXISTSGTKBOOKMARKS "true" +2
		Delete "$USERPROFILE\.gtk-bookmarks"
		StrCmp $EXISTSTHUMBNAILS "true" TheRealEnd
		RMDir /r "$USERPROFILE\.thumbnails\"

	TheRealEnd:
SectionEnd